 ; Ŀ
 ;   Dogbite - trim a space around a circular block.                       
 ;   Copyright 1994, 1997 by Rocket Software                               
 ;   No spell checker recognizes "woof" as a word.  Coincidence?           
 ; 

 ; Ŀ
 ;   Perox - error handler.                                                
 ; 
 (DEFUN PEROX (shk /)
  (setq *error* esav)
  (if (/= shk "Function cancelled")
      (write-line shk)
      (write-line "\nDogbite!"))
  (setvar "snapmode" snapp)
  (setvar "angbase" angbas)
  (setvar "blipmode" blip)
 (princ))
 ; Ŀ
 ;   Perox end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Ccut - chop around a circle.                               
 ;   Takes three arguments: the block ename, circle centre and diameter.   
 ; 
 (DEFUN CCUT (enam ccen crab / outrag ccirc ang)
  (setq outrag (* 2 (sqrt 2) crab))
  (command "circle" ccen "d" outrag)
  (setq ccirc (entlast))
  (command "trim" "l" "" "f")
  (setq ang 0)
  (while (<= ang (* pi 2))
         (command (polar ccen ang (* outrag 0.45)))
         (setq ang (+ ang (/ pi 16))))
  (command (polar ccen ang (* outrag 0.45)))
  (command "" "")
  (entdel ccirc)
  (command "erase" "wp")
  (setq ang 0)
  (while (<= ang (* pi 2))
         (command (polar ccen ang (* outrag 0.45)))
         (setq ang (+ ang (/ pi 16))))
  (command (polar ccen ang (* outrag 0.45)))
  (command "" "r" enam "")
  (redraw enam)
 (princ))
 ; Ŀ
 ;   Ccut end.                                                             
 ; 

 ; Ŀ
 ;   Cdat - get certain data for the largest (or only) circle in a block.  
 ;   Takes one argument, a block insertion ename, returns a list of        
 ;   the centrepoint and radius as inserted.  Calls circ.                  
 ; 
 (DEFUN CDAT (bloc / circa blint blex bly blz rota grsub cen radish dist ang)
  (setq circa (entget bloc))
 ; Ŀ
 ;   Get block data.                                                       
 ; 
  (setq blint (cdr (assoc 10 circa)))          ; insertion point
  (setq blex (cdr (assoc 41 circa)))           ; X scale
  (setq bly (cdr (assoc 42 circa)))            ; Y scale
  (setq blz (cdr (assoc 43 circa)))            ; Z scale
  (setq rota (cdr (assoc 50 circa)))           ; rotation
  (setq grsub (circ circa))                    ; call circ
  (if grsub
     (progn
          (setq cen (cadr grsub))              ; offset centre from ins.
          (setq radish (car grsub))            ; circle radius
 ; Ŀ
 ;   Cen is an offset from the centre of the circle.  Must convert it to   
 ;   a position.  Don't forget the block scale factor.                     
 ; 
          (if (/= (abs blex) (abs bly))        ; i.e. X = Y or X = -Y
              (prompt "\nBlock scale factors are not equal")
              (progn
                   (setq radish (* radish (abs blex))) ; radius x scale
 ; Ŀ
 ;   Now scale the circle centre offset from the insertion point by the    
 ;   appropriate scale factors.                                            
 ; 
                   (setq cen (list (* blex (car cen))
                                   (* bly (cadr cen))
                                   (* blz (caddr cen))))
 ; Ŀ
 ;   Get the distance and angle from the block insertion to the circle     
 ;   centre.                                                               
 ; 
                   (setq dist (distance (list 0 0 0) cen))
                   (setq ang (angle (list 0 0 0) cen))
 ; Ŀ
 ;   Adjust the angle for the block rotation.                              
 ; 
                   (setq ang (+ ang rota))
 ; Ŀ
 ;   And get the new centre point.                                         
 ; 
                   (setq cen (polar blint ang dist))))))
  (if (and cen radish)
      (list cen radish)
      ()))
 ; Ŀ
 ;   Cdat end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Circ: find the appropriate circle in a block definition.   
 ; 
 (DEFUN CIRC (blnam / blok namm entt typp clist grsub sub grdiam num)
  (setq blnam (cdr (assoc 2 blnam)))        ; block definition name
 ; Ŀ
 ;   Find the block definition in the block table.                         
 ; 
  (setq blok (tblsearch "block" blnam))     ; head data from table
  (setq namm (cdr (assoc -2 blok)))         ; first ename after head
 ; Ŀ
 ;   The 10 association code from the subentity data represents an offset  
 ;   from the insertion point.                                             
 ; 
  (setq typp (cdr (assoc 0 (setq entt (entget namm)))))
  (if (or (= typp "CIRCLE") (= typp "ARC"))
 ; Ŀ
 ;   If the entity was a circle then append the centre point and radius    
 ;   to the list for later appraisal.                                      
 ; 
      (setq clist (append clist (list (list (cdr (assoc 40 entt))
                                                    (cdr (assoc 10 entt)))))))
 ; Ŀ
 ;   Note: entnext returns nil after the last entity in a block            
 ;   definition.                                                           
 ; 
  (while (setq namm (entnext namm))          ; next subentity ename
         (setq typp (cdr (assoc 0 (setq entt (entget namm)))))
         (if (or (= typp "CIRCLE") (= typp "ARC"))
 ; Ŀ
 ;   If the subentity was a circle then append the centre point and        
 ;   radius to the list for later appraisal.                               
 ; 
         (setq clist (append clist (list (list (cdr (assoc 40 entt))
                                               (cdr (assoc 10 entt))))))))
 ; Ŀ
 ;   Should now have a list of lists: centre and radius for each circle    
 ;   in the block.  If the block contained no circles then clist will be   
 ;   nil and the the routine should end.                                   
 ; 
 ; Ŀ
 ;   Now find the largest circle (assumed to be the outline.)              
 ;   More complex criteria can be considered, but 99% of the time there    
 ;   will only be one circle.  It is not realistically possible to         
 ;   anticipate the circumstances which would lead to the use of this      
 ;   routine on a block containing multiple or offset circles or to        
 ;   foresee what the design of the block would be.                        
 ; 
 ; Ŀ
 ;   If there is only one circle in the block, use it.                     
 ; 
  (cond ((= (length clist) 1)
         (setq grsub (car clist)))
 ; Ŀ
 ;   If there are > 1.                                                     
 ; 
        ((> (length clist) 1)
         (setq sub (nth 0 clist))
         (setq grsub sub)
         (setq grdiam (car sub))
         (setq num 1)
         (while (setq sub (nth num clist))
                (if (> (car sub) grdiam)
                    (progn
                        (setq grsub sub)
                        (setq grdiam (car sub))))
                (setq num (1+ num)))))
 grsub)
 ; Ŀ
 ;   Subroutine Circ end.                                                  
 ; 

 ; Ŀ
 ;   Dogbite.                                                              
 ; 
 (DEFUN C:DOGBITE (/ esav snapp angbas blip cd thr enam cdata ccen crab)
  (setvar "cmdecho" 0)
  (command "undo" "m")
 ; Ŀ
 ;   Initialize new error handler, turn off snap, save settings, make      
 ;   first prompt string, etc.                                             
 ; 
  (setq esav *error*)
  (setq *error* perox)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (setq angbas (getvar "angbase"))
  (setvar "angbase" 0)
  (setvar "plinewid" 0)
  (setvar "osmode" 0)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq cd (getvar "cdate"))
  (setq thr (fix (* 100 (- cd (fix cd)))))
  (if (< 12 thr)
      (progn
           (if (< 17 thr)
               (setq thr "evening")
               (setq thr "afternoon")))
      (setq thr "morning"))
  (setq thr (strcat "Good " thr ", please select a block: "))
 ; Ŀ
 ;   Get the entity data for the block insertion to cut around.            
 ; 
  (if (and (setq enam (car (entsel thr)))
           (setvar "snapmode" snapp)
           (= "INSERT" (cdr (assoc 0 (entget enam))))
           (setq cdata (cdat enam)))
      (progn
           (setq ccen (car cdata))
           (setq crab (cadr cdata))
 ; Ŀ
 ;   And do so.                                                            
 ; 
           (ccut enam ccen crab))
      (if enam
         (write-line "\nBad dog! Bad selection!")
         (write-line "\nNear miss, Fido.")))
 ; Ŀ
 ;   Clean up and go home.                                                 
 ; 
  (setvar "snapmode" snapp)
  (setvar "angbase" angbas)
  (setvar "blipmode" blip)
  (setq *error* esav)
 (princ))